Imports System

'
' Egzemplarze tej klasy reprezentuj pojedyncze znaki wchodzce w skad dokumentu.
'
Friend Class DocChar
    Inherits DocumentElement
    Private character As Char

    ' Konstruktor egzemplarza reprezentujcego pojedynczy znak.
    ' c - Znakznak, ktry bdzie reprezentowany przez nowy obiekt.
    Friend Sub New(ByVal c As Char)
        character = c
    End Sub

    '...

    '
    ' Znak reprezentowany przez ten obiekt.
    '
    Protected Friend Overridable ReadOnly Property TheChar() As Char
        Get
            Return character
        End Get
    End Property

    '
    ' Unikatowa warto okrelajca miejsce wewntrznego skadowania danego obiektu
    ' w kolekcji typu HashCode.
    '
    Public ReadOnly Property HashCode() As Integer
        Get
            Return Convert.ToInt32(TheChar)
        End Get
    End Property

    '
    ' Ponownie definiuje funkcj Equals, aby dwa obiekty klasy DocChar byy traktowane
    ' jak egzemplarze identyczne, jeli reprezentuj ten sam znak.
    '
    Public Overloads Function Equals(ByVal o As Object) As Boolean
        If o Is Nothing Or Not (TypeOf o Is DocChar) Then
            Return False
        End If
        Return CType(o, DocChar).TheChar = TheChar
    End Function ' Equals(Object)

    '
    ' Jeli przykrywamy funkcj Equals, zawsze powinnimy przykrywa take funkcj GetHashCode.
    '
    Public Overrides Function GetHashCode() As Integer
        Return Convert.ToInt32(TheChar)
    End Function ' GetHashCode

End Class 'DocChar
